/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.complexmaterials;

import net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings;
import net.fabricmc.fabric.api.registry.FlammableBlockRegistry;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_3489;
import net.minecraft.class_3620;
import net.minecraft.class_4970;
import net.minecraft.class_6862;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.blocks.BaseBarkBlock;
import org.betterx.bclib.blocks.BaseBarrelBlock;
import org.betterx.bclib.blocks.BaseBlock;
import org.betterx.bclib.blocks.BaseBookshelfBlock;
import org.betterx.bclib.blocks.BaseChestBlock;
import org.betterx.bclib.blocks.BaseComposterBlock;
import org.betterx.bclib.blocks.BaseCraftingTableBlock;
import org.betterx.bclib.blocks.BaseDoorBlock;
import org.betterx.bclib.blocks.BaseFenceBlock;
import org.betterx.bclib.blocks.BaseGateBlock;
import org.betterx.bclib.blocks.BaseLadderBlock;
import org.betterx.bclib.blocks.BaseRotatedPillarBlock;
import org.betterx.bclib.blocks.BaseSignBlock;
import org.betterx.bclib.blocks.BaseSlabBlock;
import org.betterx.bclib.blocks.BaseStairsBlock;
import org.betterx.bclib.blocks.BaseStripableLogBlock;
import org.betterx.bclib.blocks.BaseTrapdoorBlock;
import org.betterx.bclib.blocks.BaseWoodenButtonBlock;
import org.betterx.bclib.blocks.StripableBarkBlock;
import org.betterx.bclib.blocks.WoodenPressurePlateBlock;
import org.betterx.bclib.complexmaterials.ComplexMaterial;
import org.betterx.bclib.complexmaterials.entry.BlockEntry;
import org.betterx.bclib.complexmaterials.entry.RecipeEntry;
import org.betterx.bclib.config.PathConfig;
import org.betterx.bclib.recipes.BCLRecipeBuilder;
import org.betterx.worlds.together.tag.v3.CommonBlockTags;
import org.betterx.worlds.together.tag.v3.CommonItemTags;
import org.betterx.worlds.together.tag.v3.CommonPoiTags;
import org.betterx.worlds.together.tag.v3.TagManager;

public class WoodenComplexMaterial
extends ComplexMaterial {
    public static final class_2960 MATERIAL_ID = BCLib.makeID("wooden_material");
    public static final String BLOCK_CRAFTING_TABLE = "crafting_table";
    public static final String BLOCK_STRIPPED_BARK = "stripped_bark";
    public static final String BLOCK_STRIPPED_LOG = "stripped_log";
    public static final String BLOCK_PRESSURE_PLATE = "plate";
    public static final String BLOCK_BOOKSHELF = "bookshelf";
    public static final String BLOCK_COMPOSTER = "composter";
    public static final String BLOCK_TRAPDOOR = "trapdoor";
    public static final String BLOCK_BARREL = "barrel";
    public static final String BLOCK_BUTTON = "button";
    public static final String BLOCK_LADDER = "ladder";
    public static final String BLOCK_PLANKS = "planks";
    public static final String BLOCK_STAIRS = "stairs";
    public static final String BLOCK_CHEST = "chest";
    public static final String BLOCK_FENCE = "fence";
    public static final String BLOCK_BARK = "bark";
    public static final String BLOCK_DOOR = "door";
    public static final String BLOCK_GATE = "gate";
    public static final String BLOCK_SIGN = "sign";
    public static final String BLOCK_SLAB = "slab";
    public static final String BLOCK_LOG = "log";
    public static final String TAG_LOGS = "logs";
    public final class_3620 planksColor;
    public final class_3620 woodColor;

    public WoodenComplexMaterial(String modID, String baseName, String receipGroupPrefix, class_3620 woodColor, class_3620 planksColor) {
        super(modID, baseName, receipGroupPrefix);
        this.planksColor = planksColor;
        this.woodColor = woodColor;
    }

    protected FabricBlockSettings getBlockSettings() {
        return FabricBlockSettings.copyOf((class_4970)class_2246.field_10161).mapColor(this.planksColor);
    }

    @Override
    public class_2960 getMaterialID() {
        return MATERIAL_ID;
    }

    @Override
    protected void initTags() {
        this.addBlockTag(TagManager.BLOCKS.makeTag(this.getModID(), this.getBaseName() + "_logs"));
        this.addItemTag(TagManager.ITEMS.makeTag(this.getModID(), this.getBaseName() + "_logs"));
    }

    @Override
    protected void initDefault(class_4970.class_2251 blockSettings, class_1792.class_1793 itemSettings) {
        this.initBase(blockSettings, itemSettings);
        this.initStorage(blockSettings, itemSettings);
        this.initDecorations(blockSettings, itemSettings);
    }

    protected final void initBase(class_4970.class_2251 blockSettings, class_1792.class_1793 itemSettings) {
        class_6862<class_2248> tagBlockLog = this.getBlockTag(TAG_LOGS);
        class_6862<class_1792> tagItemLog = this.getItemTag(TAG_LOGS);
        this.addBlockEntry(new BlockEntry(BLOCK_STRIPPED_LOG, (complexMaterial, settings) -> new BaseRotatedPillarBlock((class_4970.class_2251)settings)).setBlockTags(class_3481.field_15475, class_3481.field_23210, tagBlockLog).setItemTags(class_3489.field_15539, class_3489.field_23212, tagItemLog));
        this.addBlockEntry(new BlockEntry(BLOCK_STRIPPED_BARK, (complexMaterial, settings) -> new BaseBarkBlock((class_4970.class_2251)settings)).setBlockTags(class_3481.field_15475, class_3481.field_23210, tagBlockLog).setItemTags(class_3489.field_15539, class_3489.field_23212, tagItemLog));
        this.addBlockEntry(new BlockEntry(BLOCK_LOG, (complexMaterial, settings) -> new BaseStripableLogBlock(this.woodColor, this.getBlock(BLOCK_STRIPPED_LOG))).setBlockTags(class_3481.field_15475, class_3481.field_23210, tagBlockLog).setItemTags(class_3489.field_15539, class_3489.field_23212, tagItemLog));
        this.addBlockEntry(new BlockEntry(BLOCK_BARK, (complexMaterial, settings) -> new StripableBarkBlock(this.woodColor, this.getBlock(BLOCK_STRIPPED_BARK))).setBlockTags(class_3481.field_15475, class_3481.field_23210, tagBlockLog).setItemTags(class_3489.field_15539, class_3489.field_23212, tagItemLog));
        this.addBlockEntry(new BlockEntry(BLOCK_PLANKS, (complexMaterial, settings) -> new BaseBlock((class_4970.class_2251)settings)).setBlockTags(class_3481.field_15471).setItemTags(class_3489.field_15537));
        this.addBlockEntry(new BlockEntry(BLOCK_STAIRS, (complexMaterial, settings) -> new BaseStairsBlock(this.getBlock(BLOCK_PLANKS), false)).setBlockTags(class_3481.field_15502, class_3481.field_15459).setItemTags(class_3489.field_15557, class_3489.field_15526));
        this.addBlockEntry(new BlockEntry(BLOCK_SLAB, (complexMaterial, settings) -> new BaseSlabBlock(this.getBlock(BLOCK_PLANKS), false)).setBlockTags(class_3481.field_15468, class_3481.field_15469).setItemTags(class_3489.field_15534, class_3489.field_15535));
        this.addBlockEntry(new BlockEntry(BLOCK_FENCE, (complexMaterial, settings) -> new BaseFenceBlock(this.getBlock(BLOCK_PLANKS))).setBlockTags(class_3481.field_16584, class_3481.field_17619).setItemTags(class_3489.field_16585, class_3489.field_17620));
        this.addBlockEntry(new BlockEntry(BLOCK_GATE, (complexMaterial, settings) -> new BaseGateBlock(this.getBlock(BLOCK_PLANKS))).setBlockTags(class_3481.field_25147));
        this.addBlockEntry(new BlockEntry(BLOCK_BUTTON, (complexMaterial, settings) -> new BaseWoodenButtonBlock(this.getBlock(BLOCK_PLANKS))).setBlockTags(class_3481.field_15493, class_3481.field_15499).setItemTags(class_3489.field_15551, class_3489.field_15555));
        this.addBlockEntry(new BlockEntry(BLOCK_PRESSURE_PLATE, (complexMaterial, settings) -> new WoodenPressurePlateBlock(this.getBlock(BLOCK_PLANKS))).setBlockTags(class_3481.field_24076, class_3481.field_15477).setItemTags(class_3489.field_15540));
        this.addBlockEntry(new BlockEntry(BLOCK_TRAPDOOR, (complexMaterial, settings) -> new BaseTrapdoorBlock(this.getBlock(BLOCK_PLANKS))).setBlockTags(class_3481.field_15487, class_3481.field_15491).setItemTags(class_3489.field_15548, class_3489.field_15550));
        this.addBlockEntry(new BlockEntry(BLOCK_DOOR, (complexMaterial, settings) -> new BaseDoorBlock(this.getBlock(BLOCK_PLANKS))).setBlockTags(class_3481.field_15495, class_3481.field_15494).setItemTags(class_3489.field_15553, class_3489.field_15552));
        this.addBlockEntry(new BlockEntry(BLOCK_LADDER, (complexMaterial, settings) -> new BaseLadderBlock(this.getBlock(BLOCK_PLANKS))).setBlockTags(class_3481.field_22414));
        this.addBlockEntry(new BlockEntry(BLOCK_SIGN, (complexMaterial, settings) -> new BaseSignBlock(this.getBlock(BLOCK_PLANKS))).setBlockTags(class_3481.field_15500).setItemTags(class_3489.field_15533));
    }

    protected final void initStorage(class_4970.class_2251 blockSettings, class_1792.class_1793 itemSettings) {
        this.addBlockEntry(new BlockEntry(BLOCK_CHEST, (complexMaterial, settings) -> new BaseChestBlock(this.getBlock(BLOCK_PLANKS))).setBlockTags(CommonBlockTags.CHEST, CommonBlockTags.WOODEN_CHEST).setItemTags(CommonItemTags.CHEST, CommonItemTags.WOODEN_CHEST));
        this.addBlockEntry(new BlockEntry(BLOCK_BARREL, (complexMaterial, settings) -> new BaseBarrelBlock(this.getBlock(BLOCK_PLANKS))).setBlockTags(CommonBlockTags.BARREL, CommonBlockTags.WOODEN_BARREL).setItemTags(CommonItemTags.BARREL, CommonItemTags.WOODEN_BARREL));
    }

    protected void initDecorations(class_4970.class_2251 blockSettings, class_1792.class_1793 itemSettings) {
        this.addBlockEntry(new BlockEntry(BLOCK_CRAFTING_TABLE, (cmx, settings) -> new BaseCraftingTableBlock(this.getBlock(BLOCK_PLANKS))).setBlockTags(CommonBlockTags.WORKBENCHES).setItemTags(CommonItemTags.WORKBENCHES));
        this.addBlockEntry(new BlockEntry(BLOCK_BOOKSHELF, (cmx, settings) -> new BaseBookshelfBlock(this.getBlock(BLOCK_PLANKS))).setBlockTags(CommonBlockTags.BOOKSHELVES));
        this.addBlockEntry(new BlockEntry(BLOCK_COMPOSTER, (complexMaterial, settings) -> new BaseComposterBlock(this.getBlock(BLOCK_PLANKS))).setBlockTags(CommonPoiTags.FARMER_WORKSTATION));
    }

    @Override
    protected void initFlammable(FlammableBlockRegistry registry) {
        this.getBlocks().forEach(block -> registry.add(block, 5, 20));
        registry.add(this.getBlock(BLOCK_LOG), 5, 5);
        registry.add(this.getBlock(BLOCK_BARK), 5, 5);
        registry.add(this.getBlock(BLOCK_STRIPPED_LOG), 5, 5);
        registry.add(this.getBlock(BLOCK_STRIPPED_BARK), 5, 5);
    }

    @Override
    public void initDefaultRecipes() {
        class_2248 planks = this.getBlock(BLOCK_PLANKS);
        this.addRecipeEntry(new RecipeEntry(BLOCK_PLANKS, (material, config, id) -> {
            class_2248 log_stripped = this.getBlock(BLOCK_STRIPPED_LOG);
            class_2248 bark_stripped = this.getBlock(BLOCK_STRIPPED_BARK);
            class_2248 log = this.getBlock(BLOCK_LOG);
            class_2248 bark = this.getBlock(BLOCK_BARK);
            BCLRecipeBuilder.crafting(id, (class_1935)planks).checkConfig((PathConfig)config).setOutputCount(4).setList("#").addMaterial('#', new class_1935[]{log, bark, log_stripped, bark_stripped}).setGroup(this.receipGroupPrefix + "_planks").build();
        }));
        this.addRecipeEntry(new RecipeEntry(BLOCK_STAIRS, (material, config, id) -> BCLRecipeBuilder.crafting(id, (class_1935)this.getBlock(BLOCK_STAIRS)).checkConfig((PathConfig)config).setOutputCount(4).setShape("#  ", "## ", "###").addMaterial('#', new class_1935[]{planks}).setGroup(this.receipGroupPrefix + "_planks_stairs").build()));
        this.addRecipeEntry(new RecipeEntry(BLOCK_SLAB, (material, config, id) -> BCLRecipeBuilder.crafting(id, (class_1935)this.getBlock(BLOCK_SLAB)).checkConfig((PathConfig)config).setOutputCount(6).setShape("###").addMaterial('#', new class_1935[]{planks}).setGroup(this.receipGroupPrefix + "_planks_slabs").build()));
        this.addRecipeEntry(new RecipeEntry(BLOCK_FENCE, (material, config, id) -> BCLRecipeBuilder.crafting(id, (class_1935)this.getBlock(BLOCK_FENCE)).checkConfig((PathConfig)config).setOutputCount(3).setShape("#I#", "#I#").addMaterial('#', new class_1935[]{planks}).addMaterial('I', new class_1935[]{class_1802.field_8600}).setGroup(this.receipGroupPrefix + "_planks_fences").build()));
        this.addRecipeEntry(new RecipeEntry(BLOCK_GATE, (material, config, id) -> BCLRecipeBuilder.crafting(id, (class_1935)this.getBlock(BLOCK_GATE)).checkConfig((PathConfig)config).setShape("I#I", "I#I").addMaterial('#', new class_1935[]{planks}).addMaterial('I', new class_1935[]{class_1802.field_8600}).setGroup(this.receipGroupPrefix + "_planks_gates").build()));
        this.addRecipeEntry(new RecipeEntry(BLOCK_BUTTON, (material, config, id) -> BCLRecipeBuilder.crafting(id, (class_1935)this.getBlock(BLOCK_BUTTON)).checkConfig((PathConfig)config).setList("#").addMaterial('#', new class_1935[]{planks}).setGroup(this.receipGroupPrefix + "_planks_buttons").build()));
        this.addRecipeEntry(new RecipeEntry("pressure_plate", (material, config, id) -> BCLRecipeBuilder.crafting(id, (class_1935)this.getBlock(BLOCK_PRESSURE_PLATE)).checkConfig((PathConfig)config).setShape("##").addMaterial('#', new class_1935[]{planks}).setGroup(this.receipGroupPrefix + "_planks_plates").build()));
        this.addRecipeEntry(new RecipeEntry(BLOCK_TRAPDOOR, (material, config, id) -> BCLRecipeBuilder.crafting(id, (class_1935)this.getBlock(BLOCK_TRAPDOOR)).checkConfig((PathConfig)config).setOutputCount(2).setShape("###", "###").addMaterial('#', new class_1935[]{planks}).setGroup(this.receipGroupPrefix + "_trapdoors").build()));
        this.addRecipeEntry(new RecipeEntry(BLOCK_DOOR, (material, config, id) -> BCLRecipeBuilder.crafting(id, (class_1935)this.getBlock(BLOCK_DOOR)).checkConfig((PathConfig)config).setOutputCount(3).setShape("##", "##", "##").addMaterial('#', new class_1935[]{planks}).setGroup(this.receipGroupPrefix + "_doors").build()));
        this.addRecipeEntry(new RecipeEntry(BLOCK_CRAFTING_TABLE, (material, config, id) -> BCLRecipeBuilder.crafting(id, (class_1935)this.getBlock(BLOCK_CRAFTING_TABLE)).checkConfig((PathConfig)config).setShape("##", "##").addMaterial('#', new class_1935[]{planks}).setGroup(this.receipGroupPrefix + "_tables").build()));
        this.addRecipeEntry(new RecipeEntry(BLOCK_LADDER, (material, config, id) -> BCLRecipeBuilder.crafting(id, (class_1935)this.getBlock(BLOCK_LADDER)).checkConfig((PathConfig)config).setOutputCount(3).setShape("I I", "I#I", "I I").addMaterial('#', new class_1935[]{planks}).addMaterial('I', new class_1935[]{class_1802.field_8600}).setGroup(this.receipGroupPrefix + "_ladders").build()));
        this.addRecipeEntry(new RecipeEntry(BLOCK_SIGN, (material, config, id) -> BCLRecipeBuilder.crafting(id, (class_1935)this.getBlock(BLOCK_SIGN)).checkConfig((PathConfig)config).setOutputCount(3).setShape("###", "###", " I ").addMaterial('#', new class_1935[]{planks}).addMaterial('I', new class_1935[]{class_1802.field_8600}).setGroup(this.receipGroupPrefix + "_signs").build()));
        this.addRecipeEntry(new RecipeEntry(BLOCK_CHEST, (material, config, id) -> BCLRecipeBuilder.crafting(id, (class_1935)this.getBlock(BLOCK_CHEST)).checkConfig((PathConfig)config).setShape("###", "# #", "###").addMaterial('#', new class_1935[]{planks}).setGroup(this.receipGroupPrefix + "_chests").build()));
        this.addRecipeEntry(new RecipeEntry(BLOCK_BARREL, (material, config, id) -> BCLRecipeBuilder.crafting(id, (class_1935)this.getBlock(BLOCK_BARREL)).checkConfig((PathConfig)config).setShape("#S#", "# #", "#S#").addMaterial('#', new class_1935[]{planks}).addMaterial('S', new class_1935[]{this.getBlock(BLOCK_SLAB)}).setGroup(this.receipGroupPrefix + "_barrels").build()));
        this.addRecipeEntry(new RecipeEntry(BLOCK_BOOKSHELF, (material, config, id) -> BCLRecipeBuilder.crafting(id, (class_1935)this.getBlock(BLOCK_BOOKSHELF)).checkConfig((PathConfig)config).setShape("###", "PPP", "###").addMaterial('#', new class_1935[]{planks}).addMaterial('P', new class_1935[]{class_1802.field_8529}).setGroup(this.receipGroupPrefix + "_bookshelves").build()));
        this.addRecipeEntry(new RecipeEntry(BLOCK_BARK, (material, config, id) -> BCLRecipeBuilder.crafting(id, (class_1935)this.getBlock(BLOCK_BARK)).checkConfig((PathConfig)config).setShape("##", "##").addMaterial('#', new class_1935[]{this.getBlock(BLOCK_LOG)}).setOutputCount(3).build()));
        this.addRecipeEntry(new RecipeEntry(BLOCK_LOG, (material, config, id) -> BCLRecipeBuilder.crafting(id, (class_1935)this.getBlock(BLOCK_LOG)).checkConfig((PathConfig)config).setShape("##", "##").addMaterial('#', new class_1935[]{this.getBlock(BLOCK_BARK)}).setOutputCount(3).build()));
        this.addRecipeEntry(new RecipeEntry(BLOCK_STRIPPED_BARK, (material, config, id) -> BCLRecipeBuilder.crafting(id, (class_1935)this.getBlock(BLOCK_STRIPPED_BARK)).checkConfig((PathConfig)config).setShape("##", "##").addMaterial('#', new class_1935[]{this.getBlock(BLOCK_STRIPPED_LOG)}).setOutputCount(3).build()));
        this.addRecipeEntry(new RecipeEntry(BLOCK_STRIPPED_LOG, (material, config, id) -> BCLRecipeBuilder.crafting(id, (class_1935)this.getBlock(BLOCK_STRIPPED_LOG)).checkConfig((PathConfig)config).setShape("##", "##").addMaterial('#', new class_1935[]{this.getBlock(BLOCK_STRIPPED_BARK)}).setOutputCount(3).build()));
        this.addRecipeEntry(new RecipeEntry(BLOCK_COMPOSTER, (material, config, id) -> BCLRecipeBuilder.crafting(id, (class_1935)this.getBlock(BLOCK_COMPOSTER)).checkConfig((PathConfig)config).setShape("# #", "# #", "###").addMaterial('#', new class_1935[]{this.getBlock(BLOCK_SLAB)}).build()));
    }
}

